:: ------------------------------------------------
:: Usage: RunBldUG NN SEND
::   where NN is the two-digit release number
::         SEND is any text; if absent, .zip files are created but not uploaded.
:: ------------------------------------------------
:: RunBldUG creates, archives, and uploads each version of the Mif2Go UG,
:: except that the PDF version is only archived and uploaded.  
:: Every .ini is copied to a backup dir, with extension .iNN, where NN
:: is the two-digit release number.
:: A log file is created in the UG dir, then moved to the Out dir at the end.

@echo off
echo +++++++++++++++++++++++++++++++++++++++++
echo RunBldUG %1 starting %DATE% at %TIME%. >> g:\omnisys\ug\ug33v%1.log
if "%2" == "" echo **** NOTE: Files will not be uploaded *** >> g:\omnisys\ug\ug33v%1.log

if "%1" == "" goto NOARG
cd g:\omnisys\UG\out
@echo on
copy /Y G:\OmniSys\UG\cfg\*.ini G:\OmniSys\UG\cfg\CFGbackup\*.i%1
copy /Y G:\OmniSys\UG\css\*.css G:\OmniSys\UG\css\CSSbackup\*.c%1

:WINHELP
runfm -book g:\omnisys\ug\usergd.book -project WinHelp -close all -log ug33v%1.log > ug33v%1.log 2>&1
rename G:\OmniSys\UG\hlp\done\USERGD.HLP G:\OmniSys\UG\hlp\done\UserGd.hlp 
"g:\program files\winzip\wzzip" ughlp%1.zip UserGd.hlp UserGd.cnt
copy /Y G:\OmniSys\UG\hlp\*.ini G:\OmniSys\UG\hlp\WHbackup\*.i%1
if not "%2" == "" call ftpthis %1 hlp
if errorlevel 1 goto FAILED

:SOURCE
copy ugfrm00.zip ugfrm%1.zip
if not "%2" == "" call ftpthis %1 frm
if errorlevel 1 goto FAILED

:DITA
runfm -book g:\omnisys\ug\usergd.book -project DITA -close all -log ug33v%1.log  > ug33v%1.log 2>&1
copy /Y G:\OmniSys\UG\dita\*.ini G:\OmniSys\UG\dita\DITAbackup\*.i%1
if not "%2" == "" call ftpthis %1 dita
if errorlevel 1 goto FAILED

:DOCBOOK
runfm -book g:\omnisys\ug\usergd.book -project DocBook -close all -log ug33v%1.log  > ug33v%1.log 2>&1
copy /Y G:\OmniSys\UG\docbk\*.ini G:\OmniSys\UG\docbk\DBbackup\*.i%1
if not "%2" == "" call ftpthis %1 dbk
if errorlevel 1 goto FAILED

:ECLIPSEHELP
runfm -book g:\omnisys\ug\usergd.book -project "Eclipse Help" -close all -log ug33v%1.log  > ug33v%1.log 2>&1
copy /Y G:\OmniSys\UG\eh\*.ini G:\OmniSys\UG\eh\EHbackup\*.i%1
if not "%2" == "" call ftpthis %1 ecl
if errorlevel 1 goto FAILED

:HTMLHELP
runfm -book g:\omnisys\ug\usergd.book -project "HTML Help" -close all -log ug33v%1.log  > ug33v%1.log 2>&1
copy /Y G:\OmniSys\UG\hh\*.ini G:\OmniSys\UG\hh\HHbackup\*.i%1
if not "%2" == "" call ftpthis %1 chm
if errorlevel 1 goto FAILED

:HTML
runfm -book g:\omnisys\ug\usergd.book -project HTML -close all -log ug33v%1.log  > ug33v%1.log 2>&1
copy /Y G:\OmniSys\UG\htm\*.ini G:\OmniSys\UG\htm\HTMbackup\*.i%1
if not "%2" == "" call ftpthis %1 htm
if errorlevel 1 goto FAILED

:JAVAHELP
runfm -book g:\omnisys\ug\usergd.book -project JavaHelp  -close all -log ug33v%1.log  > ug33v%1.log 2>&1
copy /Y G:\OmniSys\UG\jh\*.ini G:\OmniSys\UG\jh\JHbackup\*.i%1
if not "%2" == "" call ftpthis %1 jhm
if errorlevel 1 goto FAILED

:OMNIHELP
runfm -book g:\omnisys\ug\usergd.book -project OmniHelp  -close all -log ug33v%1.log  > ug33v%1.log 2>&1
copy /Y G:\OmniSys\UG\oh\*.ini G:\OmniSys\UG\oh\OHbackup\*.i%1
if not "%2" == "" call ftpthis %1 ohm
if errorlevel 1 goto FAILED

:ORACLEHELP
runfm -book g:\omnisys\ug\usergd.book -project OracleHelp -close all -log ug33v%1.log  > ug33v%1.log 2>&1
copy /Y G:\OmniSys\UG\ohj\*.ini G:\OmniSys\UG\ohj\OHJbackup\*.i%1
if not "%2" == "" call ftpthis %1 ohj
if errorlevel 1 goto FAILED

:PDF
"g:\program files\winzip\wzzip" ugpdf%1.zip UserGd.pdf
if not "%2" == "" call ftpthis %1 pdf
if errorlevel 1 goto FAILED

:RTF
runfm -book g:\omnisys\ug\usergd.book -project RTF -close all -log ug33v%1.log  > ug33v%1.log 2>&1
copy /Y G:\OmniSys\UG\rtf\*.ini G:\OmniSys\UG\rtf\RTFbackup\*.i%1
if not "%2" == "" call ftpthis %1 rtf
if errorlevel 1 goto FAILED

:XHTML
runfm -book g:\omnisys\ug\usergd.book -project XHTML -close all -log ug33v%1.log  > ug33v%1.log 2>&1
copy /Y G:\OmniSys\UG\xhtml\*.ini G:\OmniSys\UG\xhtml\XHbackup\*.i%1
if not "%2" == "" call ftpthis %1 xhl
if errorlevel 1 goto FAILED

@echo off
echo RunBldUG %1 finished %DATE% at %TIME%. >> g:\omnisys\ug\ug33v%1.log
echo .
dir *.%1.zip
dir *.%1.zip >> ug33v%1.log
echo .
echo +++++++++++++++++++++++++++++++++++++++++
move /Y g:\omnisys\ug\ug33v%1.log g:\omnisys\UG\out
start notepad g:\omnisys\UG\out\ug33v%1.log

goto END

:NOARG
echo         /\
echo Release number expected. 
echo ------------------------------------------------
echo Usage: RunBldUG nn
echo        where nn is the two-digit release number.
echo ------------------------------------------------
goto END

:NOHIST
echo .
echo history.txt is missing from g:\omnisys\UG\Source
goto END

:FAILED
type g:\omnisys\ug\ug33v%1.log
echo **** RunBldUG %1 aborted ****

:END







