:: ------------------------------------------------
:: Usage: RunBldUG NN SEND
::   where NN is the two-digit release number
::         SEND is any text; if absent, .zip files are created but not uploaded.
:: ------------------------------------------------
:: RunBldUG creates, archives, and uploads each version of the Mif2Go UG,
:: except that the source and PDF versions are only archived and uploaded.  
:: Every .ini is copied to a backup dir, with extension .iNN, where NN
:: is the two-digit release number.
:: A log file is created in the _LOGs dir, overwriting any existing file of the same name.
:: Search individual error logs with the regex string \n[EWQD][1-9]

@echo off
if "%1" == "" goto NOARG
echo +++++++++++++++++++++++++++++++++++++++ > g:\omnisys\ug\_logs\ug40v%1.log
echo RunBldUG %1 starting %DATE% at %TIME%. >> g:\omnisys\ug\_logs\ug40v%1.log
if "%2" == "" echo **** NOTE: Files will not be uploaded *** >> g:\omnisys\ug\_logs\ug40v%1.log 2>&1
cd g:\omnisys\UG\out
copy /Y G:\OmniSys\UG\cfg\*.ini G:\OmniSys\UG\cfg\CFGbackup\*.i%1
copy /Y G:\OmniSys\UG\css\*.css G:\OmniSys\UG\css\CSSbackup\*.c%1

:SOURCE
"C:\Program Files (x86)\WinZip\wzzip.exe" -f -p -r ugfrm00.zip *.* >> g:\omnisys\ug\_logs\ug40v%1.log 2>&1
if errorlevel 1 goto FAILED
copy ugfrm00.zip ugfrm%1.zip  >> g:\omnisys\ug\_logs\ug40v%1.log 2>&1 
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 frm
if errorlevel 1 goto FAILED

:DITA
del g:\omnisys\ug\_logs\ditalog.txt
runfm -book g:\omnisys\ug\usergd.book -project DITA -close all -log g:\omnisys\ug\_logs\runfm33v%1.log 
if errorlevel 1 goto FAILED
copy /Y G:\OmniSys\UG\dita\*.ini G:\OmniSys\UG\dita\DITAbackup\*.i%1
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 dita
if errorlevel 1 goto FAILED

:DOCBOOK
del g:\omnisys\ug\_logs\docbklog.txt
runfm -book g:\omnisys\ug\usergd.book -project DocBook -close all -log g:\omnisys\ug\_logs\runfm33v%1.log 
if errorlevel 1 goto FAILED
copy /Y G:\OmniSys\UG\docbk\*.ini G:\OmniSys\UG\docbk\DBbackup\*.i%1
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 dbk
if errorlevel 1 goto FAILED


:ECLIPSEHELP
del g:\omnisys\ug\_logs\ehlog.txt
runfm -book g:\omnisys\ug\usergd.book -project EclipseHelp -close all -log g:\omnisys\ug\_logs\runfm33v%1.log 
if errorlevel 1 goto FAILED
copy /Y G:\OmniSys\UG\eh\*.ini G:\OmniSys\UG\eh\EHbackup\*.i%1
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 ecl
if errorlevel 1 goto FAILED

:HTMLHELP
del g:\omnisys\ug\_logs\hhlog.txt
runfm -book g:\omnisys\ug\usergd.book -project "HTML Help" -close all -log g:\omnisys\ug\_logs\runfm33v%1.log 
if errorlevel 1 goto FAILED
copy /Y G:\OmniSys\UG\hh\*.ini G:\OmniSys\UG\hh\HHbackup\*.i%1
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 chm
if errorlevel 1 goto FAILED

:HTML
del g:\omnisys\ug\_logs\htmlog.txt
runfm -book g:\omnisys\ug\usergd.book -project HTML -close all -log g:\omnisys\ug\_logs\runfm33v%1.log 
if errorlevel 1 goto FAILED
copy /Y G:\OmniSys\UG\htm\*.ini G:\OmniSys\UG\htm\HTMbackup\*.i%1
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 htm
if errorlevel 1 goto FAILED

:JAVAHELP
del g:\omnisys\ug\_logs\jhlog.txt
runfm -book g:\omnisys\ug\usergd.book -project JavaHelp  -close all -log g:\omnisys\ug\_logs\runfm33v%1.log 
if errorlevel 1 goto FAILED
copy /Y G:\OmniSys\UG\jh\*.ini G:\OmniSys\UG\jh\JHbackup\*.i%1
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 jhm
if errorlevel 1 goto FAILED

:OMNIHELP
del g:\omnisys\ug\_logs\ohlog.txt
runfm -book g:\omnisys\ug\usergd.book -project OmniHelp  -close all -log g:\omnisys\ug\_logs\runfm33v%1.log 
if errorlevel 1 goto FAILED
copy /Y G:\OmniSys\UG\oh\*.ini G:\OmniSys\UG\oh\OHbackup\*.i%1
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 ohm
if errorlevel 1 goto FAILED

:ORACLEHELP
del g:\omnisys\ug\_logs\ohjlog.txt
runfm -book g:\omnisys\ug\usergd.book -project OracleHelp -close all -log g:\omnisys\ug\_logs\runfm33v%1.log 
if errorlevel 1 goto FAILED
copy /Y G:\OmniSys\UG\ohj\*.ini G:\OmniSys\UG\ohj\OHJbackup\*.i%1
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 ohj
if errorlevel 1 goto FAILED

:PDF
echo Project PDF starting >>  g:\omnisys\ug\_logs\ug40v%1.log 2>&1
"C:\Program Files (x86)\WinZip\wzzip.exe" ugpdf%1.zip ugmif2go.pdf >> g:\omnisys\ug\_logs\ug40v%1.log 2>&1
if errorlevel 1 echo goto FAILED 
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 pdf
if errorlevel 1 goto FAILED

:RTF
del g:\omnisys\ug\_logs\rtflog.txt
runfm -book g:\omnisys\ug\usergd.book -project RTF -close all -log g:\omnisys\ug\_logs\runfm33v%1.log 
if errorlevel 1 goto FAILED
copy /Y G:\OmniSys\UG\rtf\*.ini G:\OmniSys\UG\rtf\RTFbackup\*.i%1
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 rtf
if errorlevel 1 goto FAILED

:WINHELP
del g:\omnisys\ug\_logs\whlog.txt
runfm -book g:\omnisys\ug\usergd.book -project WinHelp -close all -log g:\omnisys\ug\_logs\runfm33v%1.log 
if errorlevel 1 goto FAILED
rename G:\OmniSys\UG\hlp\done\UGMIF2GO.HLP ugmif2go.hlp 
"C:\Program Files (x86)\WinZip\wzzip.exe" ughlp%1.zip G:\OmniSys\UG\hlp\done\ugmif2go.hlp G:\OmniSys\UG\hlp\done\ugmif2go.cnt
if errorlevel 1 goto FAILED
copy /Y G:\OmniSys\UG\hlp\*.ini G:\OmniSys\UG\hlp\WHbackup\*.i%1
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 hlp
if errorlevel 1 goto FAILED

:XHTML
del g:\omnisys\ug\_logs\xhlog.txt
runfm -book g:\omnisys\ug\usergd.book -project XHTML -close all -log g:\omnisys\ug\_logs\runfm33v%1.log 
if errorlevel 1 goto FAILED
copy /Y G:\OmniSys\UG\xhtml\*.ini G:\OmniSys\UG\xhtml\XHbackup\*.i%1
if not "%2" == "" call g:\omnisys\ug\bats\ftpthis %1 xhl
if errorlevel 1 goto FAILED

echo RunBldUG %1 finished %DATE% at %TIME%. >> g:\omnisys\ug\_logs\ug40v%1.log 2>&1
echo .
dir g:\omnisys\ug\out\ug*%1.zip
dir g:\omnisys\ug\out\ug*%1.zip >> g:\omnisys\ug\_logs\ug40v%1.log 2>&1
echo .
echo +++++++++++++++++++++++++++++++++++++++++
goto END

:NOARG
echo         /\
echo Release number expected. 
echo ------------------------------------------------
echo Usage: RunBldUG nn send
echo        where nn is the two-digit release number
echo        and send is any text (calls ftp)
echo ------------------------------------------------
goto END

:FAILED
type g:\omnisys\ug\_logs\ug40v%1.log
echo **** RunBldUG %1 aborted %DATE% at %TIME% **** >> g:\omnisys\ug\_logs\ug40v%1.log 2>&1

:END







